import { Panel } from "../../module/views/Panel";
import { Tools } from "../Tools";
import { getCurrentScene, hideWaiting, showPanel, showToast, showWaiting } from "../../module/ctrls";
import { JoinPanel } from "./JoinPanel";
import { PropType } from "../something/enum/PropType";
import VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN;
import TEXT_ALIGN = FYGE.TEXT_ALIGN;
import TextField = FYGE.TextField;

export class BuyPowerPanel extends Panel {
    get groupNames() {
        return ["BuyPowerPanel"]
    }

    get skinName() {
        return "BuyPowerPanel"
    }

    msgTxt: FYGE.TextField;
    exchangeBtn: FYGE.Button;
    closeBtn: FYGE.Button;

    initUi() {
        const btnTxt: TextField = this.exchangeBtn.addChild(Tools.getText(
            '20店铺积分', 36, '#ffffff',
            TEXT_ALIGN.CENTER, this.exchangeBtn.width, 0, -6
        ));

        btnTxt.textHeight = this.exchangeBtn.height;
        btnTxt.verticalAlign = VERTICAL_ALIGN.MIDDLE;
        btnTxt.bold = true;
        btnTxt.stroke = 3;
        btnTxt.strokeColor = '#21926e';

        this.msgTxt.bold = true;
        this.msgTxt.stroke = 3;
        this.msgTxt.strokeColor = '#21926e';

        this.exchangeBtn.addEventListener(FYGE.MouseEvent.CLICK, async () => {
            //购买道具
            showWaiting();
            var res = await Tools.exchange(PropType.POWER);
            hideWaiting();
            //如果是链接，弹出加入会员弹框
            if (typeof res == "string") {
                showPanel(JoinPanel, { url: res });
            }
            //成功了，关闭弹框，修改道具信息
            else if (res) {
                showToast("兑换成功");
                this.hidePanel();
                getCurrentScene().updateScene();
            }
        }, this);
    }

    start(data) {
        super.start();
    }

    initEvents() {
        super.initEvents();
    }

    removeEvents() {
        super.removeEvents();
    }
}
