import Vue from 'vue'

// 皮肤入口和渲染皮肤的配置文件
import App from '@skin'
import config from '@skin/config.js'

import log from '../v2/src/libs/log'
import commonJump from '../v2/src/constructors/common-click/common-jump'

import 'ct/libs/base'
import './styles/common.less'

// 开发使用
window.JIMU = {}
window.JIMU.log = log
window.JIMU.commonJump = commonJump

// mock数据-https://www.yuque.com/tuia/projects/esw8bv#ipxbN 公共对象
const widgetAttrs = {
  id: 1,
  jump: {
    type: 'link',
    android: 'https://www.baidu.com',
    ios: 'https://www.baidu.com',
    isCoversion: 0,
    is206Jump: 0,
    isBilling: 0,
    delay: 0
  }
}

new Vue({
  render: function (h) {
    return (
      <App config={config} widgetAttrs={widgetAttrs} />
    )
  }
}).$mount('#app')
