import styles from './index.less'

export default {
  props: {
    visible: {
      type: Boolean,
      default: false
    }
  },

  methods: {
    handleClose() {
      this.$emit('close')
    },
    stopPropagate(e) {
      e.stopPropagation()
    }
  },
  render(h) {
    const { visible, $slots } = this
    console.log('我可以看的', this, $slots.default)
    if (visible) {
      return (
        <div class={styles.mask} onClick={this.handleClose}>
          <div class={styles.popupContent} onClick={this.stopPropagate}>
            {$slots.default}
          </div>
        </div>
      )
    }
  }
}
