import ClipboardJS from 'clipboard'
import Utils from '../../libs/utils'

const delay = (time) => {
  return new Promise(resolve => {
    window.setTimeout(resolve, time)
  })
}

/**
 * 发送点击埋点
 * @param {Object} option 附带信息
 */
const clickLog = (option) => {
  return new Promise((resolve, reject) => {
    if (window.JIMU.log) {
      window.JIMU.log.sendClickData(option, resolve)
    } else {
      reject(new Error('log not ready'))
    }
  })
}

function getMd5(keys) {
  const obj = {}
  keys.forEach(item => {
    if (Utils.getUrlParameter(item)) {
      obj[item] = Utils.getUrlParameter(item)
    }
  })
  if (Object.keys(obj)[0]) {
    return `&${Object.keys(obj)[0]}=${Object.values(obj)[0]}`
  }
  return ''
}
/**
 * 拼接订单号并跳转表单页
 */
const jumpTo = jump => {
  const { android, ios, type, isCoversion } = jump
  if (type !== 'link') return

  const isIphone = navigator.userAgent.indexOf('iPhone')
  const oId = Utils.getUrlParameter('a_oId')
  const tuiaId = Utils.getUrlParameter('a_tuiaId')
  const cid = Utils.getUrlParameter('a_cid')
  const device = Utils.getUrlParameter('device')
  const md5 = getMd5(['imeiMd5', 'idfaMd5', 'oaidMd5'])
  const params = `a_oId=${oId}&a_tuiaId=${tuiaId}&a_cid=${cid}${device ? `&device=${device}` : ''}${md5}`

  const cb = () => {
    if (!isIphone) {
      if (android) {
        window.location.href = `${android.includes('?') ? `${android}&` : `${android}?`}${params}`
      }
    } else {
      if (ios) {
        window.location.href = `${ios.includes('?') ? `${ios}&` : `${ios}?`}${params}`
      }
    }
  }

  if (window.JIMU.log) {
    if (isCoversion) {
      window.JIMU.log.init({}, cb)
    } else {
      cb()
    }
  } else {
    throw new Error('log not ready')
  }
}

/**
 * 埋点 - 曝光
 * @param {Number} location 兴趣点区分标示
 */
const exposeTrack = (location = -1) => {
  console.log('埋点 - 曝光', location)

  const options = {
    group: 1,
    sign_type: 'expose',
    location: +location
  }

  try {
    clickLog(options)
  } catch (error) { }
}

/**
 * 埋点 - 点击
 * @param {Number} location 兴趣点区分标示
 */
const clickTrack = (location = -1) => {
  console.log('埋点 - 点击', location)

  const options = {
    group: 1,
    sign_type: 'click',
    location: +location
  }

  return new Promise(resolve => {
    try {
      clickLog(options).then(() => resolve())
    } catch (error) { }
  })
}

/**
 * 订单号复制到剪切板，回传广告主
 */
const copyContent = `tuia=${Utils.getUrlParameter('a_oId')}`

/**
 * 点击时复制订单号
 * @param {Array} selectorList 点击元素选择器列表
 */
const clickWithCopy = (selectorList) => {
  selectorList.forEach(element => {
    const clipboard = new ClipboardJS(element, {
      text: trigger => {
        return copyContent
      }
    })

    clipboard.on('success', e => {
      e.clearSelection()
    })

    clipboard.on('error', e => { })
  })
}

export {
  delay,
  exposeTrack,
  clickTrack,
  clickWithCopy,
  jumpTo
}
