import { delay } from '../eventTrack'

const Guide = {
  $DOM: null,
  $timeout: null,
  isShow: false,

  init(selector) {
    this.$DOM = document.getElementById(selector)
  },

  setTimeoutShow(delay = 2000, Style) {
    if (this.$timeout || this.isShow) return
    this.$timeout = window.setTimeout(async() => {
      await this._show(Style)
      this.shake(Style)
    }, delay)
  },

  cancelTimeoutShow() {
    if (this.$timeout) {
      window.clearTimeout(this.$timeout)
      this.$timeout = null
    }
  },

  async _show(Style) {
    if (this.isShow) return
    this.$DOM.classList.remove(Style['out'], Style['shake'])
    this.$DOM.classList.add(Style['in'])
    this.isShow = true
    await delay(100)
  },

  shake(Style) {
    this.$DOM.classList.add(Style['shake'])
  },

  async hide(Style) {
    if (!this.isShow) return
    this.$DOM.classList.add(Style['out'])
    this.isShow = false
    await delay(200)
    this.$DOM.classList.remove(Style['in'], Style['shake'])
  }
}

export default Guide
