const path = require('path')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')
const webpack = require('webpack')
const webpackBaseConfig = require('./webpack.base.js')
const merge = require('webpack-merge')
const { getStyle } = require('./webpack.util')

module.exports = merge(webpackBaseConfig, {
  mode: 'development',
  devtool: 'inline-source-map', // 映射对应代码  方便错误查询
  module: {
    rules: [].concat(getStyle(true))
  },
  devServer: {
    contentBase: path.resolve(__dirname, '../dist'), // 告诉服务从哪提供代码内容(静态文件这么使用)
    hot: true // hot模式开启
  },
  plugins: [
    new webpack.HotModuleReplacementPlugin(), // 热模块替换开启
    new webpack.DefinePlugin({
      'process.env': {
        JIMU_ENV: `'${process.env.NODE_ENV}'`
      }
    }),
    new MiniCssExtractPlugin({
      filename: 'css/[name].css'
    })
  ]
})
