import CommonClick from '../../constructors/common-click'
import { SpiritAnimation } from '../itemType'
import {
  addAnimationStyleElement,
  removeAnimationStyleElement
} from './animationStyleHelper'
import styles from '../widgets.less'

const SPIRIT_ANIMATION_ID_PREFIX = 'spirit_animation_'

export default {
  props: {
    widgetAttrs: Object
  },

  methods: {
    getDomId() {
      const { id } = this.widgetAttrs
      return `${SPIRIT_ANIMATION_ID_PREFIX}${id}`
    },
    getDom() {
      return document.getElementById(this.getDomId())
    },
    updateAnimation() {
      const { widgetAttrs } = this
      this.unloadAnimation()
      addAnimationStyleElement(
        widgetAttrs.id,
        widgetAttrs && widgetAttrs.spiritAnimation,
        animationClassName => {
          const dom = this.getDom()
          if (dom) {
            dom.classList.add(animationClassName)
          }
        }
      )
    },
    unloadAnimation() {
      const animationClassName = removeAnimationStyleElement(this.widgetAttrs.id)
      const dom = this.getDom()
      if (dom) {
        dom.classList.remove(animationClassName)
      }
    }

  },

  mounted() {
    this.updateAnimation()
  },

  destroyed() {
    this.unloadAnimation()
  },

  render() {
    return (
      <CommonClick
        widgetTyp={SpiritAnimation}
        widgetAttrs={this.widgetAttrs}
      >
        <div
          id={this.getDomId()}
          class={styles.widget}
          style={this.widgetAttrs.style}
        />
      </CommonClick>
    )
  }
}
