import Widgets from '../allWidgets'
import CommonClick from '../../constructors/common-click'
import styles from './index.less'

export default {
  props: {
    widgetAttrs: Object
  },

  render() {
    const { image } = this.widgetAttrs

    let subWidgetList = this.widgetAttrs.elements || []

    return (
      <CommonClick
        widgetType='popup'
        widgetAttrs={this.widgetAttrs}
      >
        <div class={styles['pop-bgwrap']}>
          {
            image.isDefault
              ? <div
                style={{ width: image.width, height: image.height }}
              />
              : <img
                src={image.url}
                style={{ width: image.width, height: image.height }}
              />
          }
          {subWidgetList.map((item, idx) => {
            const SpecWidget = Widgets[item.type]
            return <SpecWidget widgetAttrs={item} key={idx} />
          })}
        </div>
      </CommonClick>
    )
  }
}
