import PopupElement from './element'
import cn from 'classnames'
import CommonJump from '../../constructors/common-click/common-jump'
import styles from '../widgets.less'

export default {
  props: {
    widgetAttrs: Object
  },

  data() {
    return {
      popupId: '',
      timer: null
    }
  },

  mounted() {
    const { id } = this.widgetAttrs
    this.popupId = id
  },

  methods: {
    doAutoJump() {
      const componentData = this.widgetAttrs
      const { jump, autoJump, name } = componentData

      if (autoJump && autoJump.enable) {
        this.timer = setTimeout(() => {
          CommonJump({
            componentData,
            jump,
            options: { location: name },
            popupCallback: () => {
              this.$store.commit('showPopup', jump.popupId)
            },
            closeCallback: () => {
              this.$store.commit('hidePopup')
            }
          })
        }, autoJump.delay * 1000)
      }
    },

    clearAutoJump() {
      clearTimeout(this.timer)
    }
  },


  render() {
    const isThisPopup =
      this.$store.state.showingPopupId === this.popupId

    // 弹层展示后，执行自动跳转
    if (isThisPopup) {
      this.doAutoJump()
    } else {
      this.clearAutoJump()
    }

    return (
      <div
        id={this.widgetAttrs.id}
        class={cn(styles.widget, styles['popup-container'])}
        style={Object.assign({}, this.widgetAttrs.style, {
          position: 'fixed',
          display: isThisPopup ? 'block' : 'none'
        })}
      >
        <PopupElement widgetAttrs={this.widgetAttrs} />
      </div>
    )
  }
}
