import Tel from './tel.png'

export default {
  props: {
    widgetAttrs: Object
  },

  render() {
    const { text, style, icon } = this.widgetAttrs
    const { lineHeight, fontSize, textAlign } = style

    return (
      <div
        style={Object.assign(
          { lineHeight, fontSize, textAlign },
          {
            display: 'flex',
            justifyContent: 'center',
            alignItems: 'center',
            height: '100%'
          }
        )}
      >
        {style.backgroundImage ? (
          <div />
        ) : (
          <div>
            <img src={Tel} style={{
              width: '0.23rem',
              height: '0.23rem',
              marginRight: '0.1rem'
            }} />
            {text}
          </div>
        )}
      </div>
    )
  }
}
