const verifyOptions = {
  mobile: {
    pattern: /^1(3|4|5|6|7|8|9)\d{9}$/,
    message: '请输入正确的手机号！'
  },

  name: {
    pattern: /^([\u4E00-\uFA29]){2,6}$/,
    message: '姓名应为2-6位中文！'
  },

  email: {
    pattern: /^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/,
    message: '请输入有效的邮箱！'
  },

  idcard: {
    pattern: /^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}([0-9]|X|x)$/,
    message: '请输入有效的身份证号'
  }
}

const verifyRule = function(value, filedName, required, verifyType, childType) {
  let rules = []

  if (required && (value === '' || value === [] || value === null || value === undefined)) {
    rules.push({
      require: true,
      message: filedName + '不能为空'
    })
  }

  if (verifyType && verifyOptions[verifyType]) {
    if (!verifyOptions[verifyType].pattern.test(value)) {
      rules.push(verifyOptions[verifyType])
    }
  }
  console.log(rules)
  return rules
}

const verifyRules = function(form, verifySettings) {
  let rules = []

  for (let i in form) {
    const verifySetting = verifySettings[i]
    const result = verifyRule(form[i], verifySetting.title, verifySetting.required, verifySetting.verify, verifySetting.childType)
    rules = [...rules, ...result]
  }

  return rules
}

export {
  verifyRule,
  verifyRules
}
