export function trans2verifySettings(controlSetting) {
  const verifySettings = {}

  controlSetting.forEach(item => {
    if (item.childType === 'mobile' && item.sendVerifyCode) {
      verifySettings[`${item.type}_${item.childType}_code-${item.key}`] = {
        title: '验证码',
        type: item.type,
        childType: item.childType,
        required: item.required,
        verify: `${item.childType}_code`
      }
    }
    verifySettings[`${item.type}_${item.childType}-${item.key}`] = {
      title: item.title,
      type: item.type,
      childType: item.childType,
      required: item.required,
      verify: item.verify
    }
  })

  return verifySettings
}
