import Util from '@/libs/utils'
import toast from '@/libs/toast'
import map from './map'

function getTitleByKey(index, formControl) {
  for (let i = 0; i < formControl.length; i++) {
    const item = formControl[i]
    if (index === `${item.type}_${item.childType}-${item.key}`) {
      return item.title
    }
  }
}

export default function submitForm(formData, formControl, formId, formName) {
  // console.log(formData, formControl, formId, formName)

  let params = {
    landId: parseInt(window.atob(Util.getUrlParameter('id'))),
    channel: 'formTemplate'
  }

  let listUserInfoList = [
    {
      name: 'formName',
      value: formName
    },
    {
      name: 'formId',
      value: formId
    }
  ]

  for (let i in formData) {
    const idx = i.split('-')[0]
    if (map[idx]) {
      // 约定字段
      let value = formData[i]

      // 特殊处理
      switch (idx) {
        case 'select_sex':
          params[map[idx]] = parseInt(value && value[0])
          break
        case 'select_address':
          params['province'] = (value && value[0]) || ''
          params['city'] = (value && value[1]) || ''
          params['region'] = (value && value[2]) || ''
          break
        default:
          params[map[idx]] = value
          break
      }
    } else {
      let value = formData[i]

      // 特殊处理
      switch (idx) {
        case 'select_date':
          value = value || ''
          break
        case 'select_time':
          value = value || ''
          break
        case 'select_customize':
          value = value || ''
          break
        case 'radio_normal':
          value = value || ''
          break
        case 'checkbox_normal':
          value = value.join(',')
          break
        default:
          break
      }

      // 自定义字段
      listUserInfoList.push({
        name: getTitleByKey(i, formControl),
        value
      })
    }
  }

  params = Object.assign({}, params, {
    listUserInfo: JSON.stringify(listUserInfoList)
  })

  console.log(params)

  Util.ajax({
    url: '/activity/land/submitForm',
    method: 'POST',
    data: params
  }).then(res => {
    if (res.success) {
      toast('提交成功')
    } else {
      toast(res.desc)
    }
  })
}
