import { Field, Popup, DatetimePicker } from 'vant'
import utils from '@/libs/utils'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className: String
  },

  data() {
    return {
      content: '',
      show: false,
      selectType: 'date',
      currentDate: new Date()
    }
  },
  methods: {
    handleClick() {
      this.show = true
    },
    handleCancel() {
      this.show = false
    },
    handleConfirm(val) {
      this.show = false
      const value =
        this.selectType === 'date'
          ? utils.dateFormat(val, 'yyyy-MM-dd')
          : `${val}:00`
      this.content = value
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', value, fieldId)
    }
  },
  mounted() {
    const {
      childType
    } = this.formAttrs

    this.selectType = childType
    this.currentDate = childType === 'date' ? new Date() : utils.dateFormat(new Date(), 'hh:mm:00')
  },
  render: function(h) {
    const {
      title,
      placeholder,
      required,
      childType
    } = this.formAttrs

    return (
      <div class={this.className}>
        <Field
          v-model={this.content}
          required={!!required}
          input-align={this.inputLayout}
          label={this.layout === 'no-title' ? '' : title}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          placeholder={placeholder}
          onClick={this.handleClick}
          readonly
        />
        <Popup v-model={this.show} position="bottom" get-container="body" overlay={false}>
          <DatetimePicker
            show-toolbar
            v-model={this.currentDate}
            type={this.selectType}
            onCancel={this.handleCancel}
            onConfirm={this.handleConfirm} />
        </Popup>
      </div>
    )
  }
}
