import { Field, Button } from 'vant'
import { verifyRule } from '../../verify/verifyRules'
import toast from '@/libs/toast/index.js'
import { ajax } from '../../utils'
import utils from '@/libs/utils'
import { iconTypeMapping } from '../index'

export default {
  props: {
    formAttrs: Object,
    layout: String,
    inputLayout: String,
    className:  String
  },

  data() {
    return {
      phone: '',
      code: '',
      timeout: 0
    }
  },
  methods: {
    autoFill(value) {
      this.phone = value
      this.handleChange(value)
    },
    handleChange(val) {
      const { type, childType, key } = this.formAttrs
      const fieldId = `${type}_${childType}-${key}`
      this.$emit('update', val, fieldId)
    },
    handleChangeCode(val) {
      const { type, childType, key } = this.formAttrs
      const codeFieldId = `${type}_${childType}_code-${key}`
      this.$emit('update', val, codeFieldId)
    },
    handleSend() {
      const attrs = this.formAttrs
      const result = verifyRule(
        this.phone,
        attrs.title,
        attrs.required,
        attrs.childType
      )

      if (result && result.length > 0) {
        toast(result[0].message)
        return
      }

      ajax({
        url: '/activity/land/sendCode',
        params: {
          phone: this.phone,
          landId: parseInt(window.atob(utils.getUrlParameter('id'))),
          landSubId: window.atob(utils.getUrlParameter('id')) + '-1',
          channel: 'formTemplate'
        }
      }).then(res => {
        if (res.success) {
          toast('发送验证码成功')
          this.timeout = 60
          this.runTimer()
        } else {
          toast(res.desc)
        }
      })
    },

    runTimer() {
      if (!this.timeout) {
        return
      }
      setTimeout(() => {
        this.timeout -= 1
        this.runTimer()
      }, 1000)
    }
  },
  render: function(h) {
    const { title, placeholder, required, sendVerifyCode, childType } = this.formAttrs

    return (
      <div class={this.className}>
        <Field
          v-model={this.phone}
          required={!!required}
          label={this.layout === 'no-title' ? '' : title}
          left-icon={this.layout === 'icon' ? iconTypeMapping[childType] : ''}
          input-align={this.inputLayout}
          placeholder={placeholder}
          onInput={this.handleChange}
        />
        {sendVerifyCode ? (
          <div class={this.className}>
            <Field
              v-model={this.code}
              required={!!required}
              label={this.layout === 'no-title' ? '' : '验证码'}
              left-icon={this.layout === 'icon' ? iconTypeMapping['verifi'] : ''}
              input-align={this.inputLayout}
              placeholder="请输入短信验证码"
              onInput={this.handleChangeCode}
            >
              <Button
                slot="button"
                color="rgb(255, 130, 0)"
                size="small"
                plain
                onClick={this.handleSend}
              >
                { this.timeout || '发送验证码' }
              </Button>
            </Field>
          </div>
        ) : ''}
      </div>
    )
  }
}
