import FormElements from './elements'

import PubSub from 'pubsub-js'

import styles from './styles/index.less'
import './styles/vant.global.less'

export default {
  props: {
    widgetAttrs: Object,
    formType: String
  },

  data() {
    return {
      baseContent: {},
      form: {},
      controls: []
    }
  },

  created() {
    this.controls = this.widgetAttrs.controlSetting

    this.controls.forEach(item => {
      if (item.childType === 'mobile' && item.sendVerifyCode) {
        this.form[`${item.type}_${item.childType}_code-${item.key}`] = null
      }
      this.form[`${item.type}_${item.childType}-${item.key}`] = null
    })
    this.$emit('update', this.form)
  },

  beforeDestroy() {
    PubSub.unsubscribe('setUser')
  },

  mounted() {
    PubSub.subscribe('setUser', (msg, data) => {
      const {
        name,
        sex,
        phone,
        province,
        city,
        region,
        address,
      } = data
      // 自动填充
      for (const key in this.form) {
        if (key.includes('input_name-') && name) {
          this.$refs[key].autoFill(name)
          this.$store.commit('addListContext', 'name')
        } else if (key.includes('input_mobile-') && phone) {
          this.$refs[key].autoFill(phone)
          this.$store.commit('addListContext', 'phone')
        } else if (key.includes('select_sex-') && sex) {
          this.$refs[key].autoFill(sex)
          this.$store.commit('addListContext', 'sex')
        } else if (key.includes('select_address-')) {
          if (province && city && region) {
            this.$refs[key].autoFill([province, city, region])
            this.$store.commit('addListContext', 'province')
            this.$store.commit('addListContext', 'city')
            this.$store.commit('addListContext', 'region')
          }
        } else if (key.includes('input_address-') && address) {
          this.$refs[key].autoFill(address)
          this.$store.commit('addListContext', 'address')
        }
      }
    })
  },

  methods: {
    handleUpdate(val, key) {
      this.form[key] = val
      this.$emit('update', this.form)
    }
  },

  render: function(h) {
    const { baseContent, id } = this.widgetAttrs
    const { layout } = baseContent
    let _layout = 'left'
    if (layout === 'justify') {
      _layout = 'right'
    }

    let className = ''
    if (layout === 'no-title') {
      className = 'clear-width'
    } else if (layout === 'vertical') {
      className = 'column'
    }
    return (
      <div style={baseContent.style} id={id}>
        {this.controls.map(item => {
          const SpecForm = FormElements[item.type + '_' + item.childType]
          const key = `${item.type}_${item.childType}-${item.key}`
          return (
            <div class={styles['form-item']}>
              <SpecForm
                layout={layout}
                inputLayout={_layout}
                formAttrs={item}
                className={styles[className]}
                onUpdate={this.handleUpdate}
                ref={key}
              />
            </div>
          )
        })}
      </div>
    )
  }
}
