import JmButton from '../button/index.jsx'
import FormElement from './element.jsx'
import utils from '../../libs/utils'
import { trans2verifySettings, verifyRules, verifyUnique, submit } from './verify'
import toast from '../../libs/toast/index.js'
import styles from './styles/index.less'

export default {
  props: {
    widgetAttrs: Object
  },
  data() {
    return {
      form: {}
    }
  },
  methods: {
    handleUpdate(form) {
      this.form = form
    },
    handleSubmit() {
      console.log('this.form', this.form)
      const { controlSetting, id, name } = this.widgetAttrs
      const verifySettings = trans2verifySettings(controlSetting)

      // 必须使用 promise 并 relove（true），才能执行 common-jump 后续逻辑！！！
      return new Promise((resolve) => {
        const verifyRulesResult = verifyRules(this.form, verifySettings) || []
        console.log('verifyRulesResult', verifyRulesResult)
        if (verifyRulesResult.length === 0) {
          verifyUnique(controlSetting, this.form).then(() => {
            submit(
              this.form,
              controlSetting,
              id,
              name
            )
            resolve(true)
          }).catch(error => {
            console.log('unique failed', error)
            resolve(false)
          })
        } else {
          toast(verifyRulesResult[0].message)
          resolve(false)
        }
      })
    }
  },
  render: function(h) {
    let submitAttrs = utils.deepClone(this.widgetAttrs.submitVerify)
    submitAttrs.style.fontSize = 3.2 / 750 * 28 + 'rem'
    submitAttrs.style.marginTop = submitAttrs.dis + 'px'

    return (
      <div class={styles['form-container']}>
        <FormElement
          widgetAttrs={this.widgetAttrs}
          form={this.form}
          onUpdate={this.handleUpdate}
        />
        <JmButton
          widgetAttrs={submitAttrs}
          class={styles['btn-submit']}
          customClick={this.handleSubmit}
        />
      </div>
    )
  }
}
