// 测试自动填充表单
import PubSub from 'pubsub-js'
import utils from '../../../libs/utils'
import { ajax } from '../../form/utils'
import Modal from './modal'
import Popup from '@/styles/imgs/popup.png'

export default {
  methods: {
    handleCancel() {
      window.JIMU.log.sendClickData({
        type: 110,
        group: 1,
        location: 7,
        userId: utils.getUrlParameter('userId')
      })
    },
    handleOk() {
      this.$store.commit('setAuto', 1)
      window.JIMU.log.sendClickData({
        type: 110,
        group: 1,
        location: 6,
        userId: utils.getUrlParameter('userId')
      })
      this.queryMediaUserInfo()
    },
    // 获取用户信息
    queryMediaUserInfo() {
      ajax({
        url: '/sdk/put/queryMediaUserInfo',
        data: {
          userId: utils.getUrlParameter('userId'),
          orderId: utils.getUrlParameter('a_oId'),
          consumerId: utils.getUrlParameter('a_cid'),
        },
        method: 'post',
        headers: { 'Content-Type': 'application/json' }
      }).then(res => {
        if (res.code === '0' && res.data) {
          PubSub.publish('setUser', res.data)
        } else {
          Toast('获取失败，请自助填写')
        }
      }).catch(err => {
        console.log(err)
        Toast('获取失败，请自助填写')
      })
    }
  },

  render() {
    const { isShow2 } = this.$store.state
    return (
      <Modal
        show={isShow2}
        cancel={this.handleCancel}
        ok={this.handleOk}
        styles={{
          width: '2.43rem',
          height: '2.43rem'
        }}
        contentImg={Popup}
      />
    )
  }
}