import CommonClick from '../../constructors/common-click'
import styles from '../widgets.less'

import TestAutoFill from './popupForTest/index'
import utils from '../../libs/utils'

export default {
  data() {
    return {
      isAuth: false,
      isTest: false
    }
  },

  props: {
    widgetAttrs: Object
  },

  mounted() {
    const pageId = utils.getUrlParameter('id')
    const testPage = [
      'MTMwNw', // 测试环境便于测试
      'NjUzOQ', // 线上环境-酒
      'NjU0MQ' // 线上环境-羊奶
    ]
    if (testPage.includes(pageId)) {
      this.isTest = true
    }
  },

  methods: {
    customClick() {
      // 必须使用 promise 并 relove（true），才能执行 common-jump 后续逻辑！！！
      return new Promise((resolve) => {
        if (this.isAuth) {
          resolve(true)
        } else {
          if (this.isTest && this.$store.state.auto === 0) {
            this.isAuth = true
            this.$store.commit('handleTestPopup', {
              key: 'isShow2',
              value: true
            })
            window.JIMU.log.sendClickData({
              type: 110,
              group: 1,
              location: 5,
              userId: utils.getUrlParameter('userId')
            })
          }
          resolve(true)
        }
      })
    }
  },

  render() {
    const { id, style } = this.widgetAttrs
    return (
      <div>
        {
          this.isTest
            ?
            <div>
              <TestAutoFill />
              <CommonClick
                widgetType='download'
                widgetAttrs={this.widgetAttrs}
                customClick={this.customClick}
              >
                <div id={id} class={styles.widget} style={style} />
              </CommonClick>
            </div>
            :
            <CommonClick
              widgetType='download'
              widgetAttrs={this.widgetAttrs}
            >
              <div id={id} class={styles.widget} style={style} />
            </CommonClick>
        }
      </div>
    )
  }
}
