import styles from '../widgets.less'

export default {
  props: {
    widgetAttrs: Object
  },

  data() {
    return {
      value: this.widgetAttrs.start
    }
  },

  mounted() {
    this.walk()
  },

  methods: {
    walk() {
      const { start, end } = this.widgetAttrs
      let timer = null
      timer = setInterval(() => {
        if (start >= end) {
          this.value--
        } else {
          this.value++
        }
        if (this.value === end) clearInterval(timer)
      }, 1000);
    }
  },

  render() {
    const { style } = this.widgetAttrs
    return (
      <div class={styles.widget} style={style}>
        {this.value}
      </div>
    )
  }
}
