import AMap from './amap'
import Cover from './cover'

export default {
  props: {
    widgetAttrs: Object
  },

  data() {
    return {
      map: null
    }
  },

  methods: {
    reSetMarker(lnglat) {
      for (var i = 0; i < 2; i++) {
        if (
          (this.lnglat && this.lnglat[i] && this.lnglat[i] === lnglat[i]) ||
          !lnglat
        ) return
      }
      this.marker && this.marker.setMap(null)
      this.marker = new window.AMap.Marker({
        icon: 'https://webapi.amap.com/theme/v1.3/markers/n/mark_b.png',
        position: lnglat
      })
      this.marker.setMap(this.map)
      this.map.setZoomAndCenter(14, lnglat)
      this.lnglat = lnglat
    },

    onInit(map) {
      this.map = map
    }
  },

  watch: {
    map: function() {
      const { lnglat } = this.widgetAttrs
      this.map && this.reSetMarker(lnglat)
    }
  },

  render() {
    const { address } = this.widgetAttrs
    const { showType } = address

    const pos = {}
    if (showType === 2) {
      pos.top = '4px'
    } else if (showType === 1) {
      pos.bottom = '4px'
    }
    return (
      <div style={{ height: '100%' }}>
        <Cover />
        {address.text && (showType === 1 || showType === 2) && (
          <div style={Object.assign({}, address.style, pos)}>
            {address.text}
          </div>
        )}
        <AMap
          init={this.onInit}
          style={{ height: '100%' }}
        />
      </div>
    )
  }
}
