import loadjs from 'loadjs'
import uuidv4 from 'uuid/v4'

const uuidGen = () => uuidv4().split('-')[0]
const mapUUIDs = []
const mapOptions = {}
const mapCallbacks = {}

export default {
  props: {
    init: Function
  },

  beforeMount() {
    const uuid = uuidGen()
    this.uuid = uuid
    mapOptions[uuid] = {}
    mapCallbacks[uuid] = {}
  },

  mounted() {
    // 增加dom的id
    this.$refs.mapRef.id = this.uuid
    // 在实例上同步uuid
    this.uuid = this.uuid
    // 如果当前存在AMap SDK则直接初始化即可，如果未存在AMap SDK则加到初始化队列中
    window.AMap ? this.initWhenHasSDK(this.uuid) : this.initWhenNotHasSDK(this.uuid)
    // once模式加载SDK并声明回调初始化队列
    if (!loadjs.isDefined('AMap')) {
      loadjs(
        [
          `https://webapi.amap.com/maps?v=1.4.6&key=13b7051cc83cc78dcfa7bb094256139c&plugin=AMap.Marker,AMap.Autocomplete,AMap.PlaceSearch&callback=initAMaps`
        ],
        'AMap'
      )
      window.initAMaps = () => {
        mapUUIDs.forEach(mapuuid => this.initAMap(mapuuid)())
      }
    }
  },

  methods: {
    initAMap(uuid) {
      return function() {
        // 地图加载
        var map = new window.AMap.Map(uuid, {
          resizeEnable: true
        })

        // 定位
        map.plugin('AMap.Geolocation', () => {
          var geolocation = new window.AMap.Geolocation({
            enableHighAccuracy: true, // 是否使用高精度定位，默认:true
            timeout: 10000, // 超过10秒后停止定位，默认：无穷大
            buttonOffset: new window.AMap.Pixel(10, 20), // 定位按钮与设置的停靠位置的偏移量，默认：Pixel(10, 20)
            zoomToAccuracy: true, // 定位成功后调整地图视野范围使定位位置及精度范围视野内可见，默认：false
            buttonPosition: 'RB',
            scrollWheel: false
          })
          // map.addControl(geolocation)
          geolocation.getCurrentPosition()
        })
        const onInit = mapCallbacks[uuid] && mapCallbacks[uuid].onInit
        onInit && onInit(map)
      }
    },
    // 主要因为amap脚本市入口脚本，没有真正的sdk
    initWhenNotHasSDK(uuid) {
      mapUUIDs.push(uuid)
    },
    initWhenHasSDK(uuid) {
      this.initAMap(uuid)()
    }
  },

  beforeDestroy() {
    const index = mapUUIDs.findIndex(uuid => uuid === this.uuid)
    mapUUIDs.splice(index, 1)
    delete mapOptions[this.uuid]
    delete mapCallbacks[this.uuid]
  },

  render() {
    mapOptions[this.uuid] = this.options
    mapCallbacks[this.uuid].onInit = this.init
    return <div ref="mapRef" style={this.style} />
  }
}
