import Vue from 'vue'
import Vuex from 'vuex'

Vue.use(Vuex)

const store = new Vuex.Store({
  state: {
    showingPopupId: '',
    report: null,
    pageConfig: {},
    elementConfig: [],

    // 是否支持自动填充表单，1-需要，0-不需要
    needMonitor: 0,
    // 是否点击授权，1-是，0-否
    auto: 0,
    // 埋点自动填充的表单字段，1-填充，0-未填充
    listContext: {},
    // 弹层1
    isShow: false,
    // 弹层2
    isShow2: false
  },
  mutations: {
    setPageConfig(state, pageConfig) {
      state.pageConfig = pageConfig
    },
    setElementConfig(state, elementConfig) {
      state.elementConfig = elementConfig
    },
    showPopup(state, popupId) {
      state.showingPopupId = popupId
    },
    hidePopup(state) {
      state.showingPopupId = ''
    },
    setReport(state, report) {
      state.report = report
    },

    setNeedMonitor(state, data) {
      state.needMonitor = data
    },
    setAuto(state, data) {
      state.auto = data
    },
    addListContext(state, key) {
      state.listContext[key] = 1
    },
    handleTestPopup(state, data) {
      state[data.key] = data.value
    }
  }
})

export default store
