const webp = '?x-oss-process=image/format,webp'
const imageAttrs = [
  'backgroundImage'
]

// 支持图片webp
function transToWebp(source) {
  // 处理 elemrntConfig
  if (Array.isArray(source)) {
    source.map(item => {
      // 处理各个组件style
      for (let i in item.style) {
        if (imageAttrs.includes(i)) {
          item.style[i] = item.style[i].replace('")', webp)
        }
      }

      // 处理 自定义组件 type = code
      if (item.type === 'code') {
        const config = item.code && item.code.config
        for (let i in config) {
          config[i].value = config[i].value && config[i].value + webp
        }
      }

      // 处理 轮播图组件 type = carousel
      if (item.type === 'carousel') {
        item.sliders.map(subItem => {
          subItem.src = subItem.src + webp
        })
      }

      // 处理 弹层组件 type = popup
      if (item.type === 'popup') {
        item.image.url = item.image.url && item.image.url + webp
      }
    })
  } else if (Object.prototype.toString.call(source) !== '[object Object]') {
    // 处理pageConfig
    for (let i in source) {
      if (imageAttrs.includes(i)) {
        source[i] = source[i].replace('")', webp)
      }
    }
  }

  return source
}

export {
  transToWebp
}