/**
 * 初始化 webp
 * html 标签添加 webp class
 * @param { string } klass 类名，取名防止关键字冲突
 */
export function init (klass = 'ta-webp') {
  if (isSupported()) {
    const el = document.documentElement
    const className = el.className || ''

    if (className.indexOf(klass) === -1) {
      el.classList.add(klass)
    }
  }
}

let _isSupported

// 由服务端渲染出以下内容
// window.TA = window.TA || {}
// window.TA.isSupportWebp = false

/**
 * 浏览器是否支持 webp
 */
export function isSupported () {
  // 从内存直接获取
  if (_isSupported !== undefined) {
    return _isSupported
  }

  // 从全局变量里取（服务器判断是否支持 webp）
  if (window.TA && window.TA.isSupportWebp !== undefined) {
    _isSupported = window.TA.isSupportWebp
    return _isSupported
  }

  return _isSupported
}

/**
 * 获取图片 Url (是否支持 webp)
 * @param { string } url 图片 url
 */
export function getWebpUrl (url) {
  if (!url || Object.prototype.toString.call(url) !== '[object String]') {
    return url
  }

  // base64的图片不做任何处理
  if (url.indexOf('data:image') !== -1) {
    return url
  }

  // 如果已经是oss处理过的资源，不再处理
  if (url.indexOf('?x-oss-process') !== -1) {
    return url
  }

  // 浏览器是否支持 webp
  if (isSupported()) {
    return url + '?x-oss-process=image/format,webp'
  } else {
    return url
  }
}
