import Close from '@/styles/imgs/close.png'
import style from './index.less'

export default {
  props: {
    show: {
      type: Boolean,
      default: false
    },
    contentImg: {
      type: String
    },
    cancel: {
      type: Function,
      default: () => {}
    },
    ok: {
      type: Function,
      default: () => {}
    },
    styles: {
      type: Object,
      default: {}
    }
  },

  updated() {
    const $body = document.querySelector('body')
    if (this.show) {
      $body.style.overflow = 'hidden'
    } else {
      $body.style.overflow = 'auto'
    }
  },

  methods: {
    handleTestClose() {
      this.$store.commit('handleTestPopup', {
        key: 'isShow',
        value: false
      })
      this.cancel()
    },
    handleTestOk() {
      this.$store.commit('handleTestPopup', {
        key: 'isShow',
        value: false
      })
      this.ok()
    }
  },
  render(h) {
    return (
      <div class={style['popup-container']} style={{ display: this.show ? 'block' : 'none'}}>
        <div class={style['popup-mask']} />
        <div class={style['popup-wrapper']}>
          <img class={style['close']} src={Close} onClick={this.handleTestClose}/>
          <div
            class={style['pop-bgwrap']}
            style={this.styles}
          >
            <img src={this.contentImg} />
            <div class={style['btn']} onClick={this.handleTestOk}></div>
          </div>
        </div>
      </div>
    )
  }
}
