import { isIphone } from '../../libs/helper'
import log from '../../libs/log'
import utils from '../../libs/utils'
import store from '../../store'

export default function commonJumpLogic({
  componentData = {},
  jump,
  options,
  popupCallback,
  closeCallback
} = {}) {
  console.log('store.state', store.state)
  let { android, ios, type, isCoversion, isPassParams } = jump
  console.log('commonJumpLogic', componentData, jump, options)
  // 埋点id
  const { id } = componentData
  id && (options.compId = id)
  // 处理传参
  if (isPassParams) {
    // apk链接不处理
    let reg = /\.apk/g
    let params = {
      a_oId: utils.getUrlParameter('a_oId'),
      a_cid: utils.getUrlParameter('a_cid'),
      a_tuiaId: utils.getUrlParameter('a_tuiaId'),
      device: utils.getUrlParameter('device'),
      imeiMd5: utils.getUrlParameter('imeiMd5'),
      idfaMd5: utils.getUrlParameter('idfaMd5'),
      oaidMd5: utils.getUrlParameter('oaidMd5')
    }
    android =
      android && !reg.test(android) ? utils.formatUrl(android, params) : android
    ios = ios && !reg.test(android) ? utils.formatUrl(ios, params) : ios
  }
  // 点击埋点
  log.sendClickData(options, () => {
    const cb = () => {
      if (type === 'link') {
        if (!isIphone) {
          if (android) {
            if (
              jump.is206Jump &&
              navigator.userAgent.match(/micromessenger|alipay/gi)
            ) {
              jump206(android)
            } else {
              jumpTo(android)
            }
          }
        } else {
          if (ios) {
            jumpTo(ios)
          }
        }
      } else if (type === 'popup') {
        popupCallback && popupCallback()
      } else if (type === 'close') {
        closeCallback && closeCallback()
      }
    }
    if ((isCoversion || isCoversion === undefined) && type !== 'none') {
      // 转化埋点
      // 如果自动填充表单授权过的，把授权埋点区分出来
      if (store.state.needMonitor) {
        const newOption = Object.assign({}, options, {
          userId: utils.getUrlParameter('userId'),
          isAutoCommit: store.state.auto,
          listContext: store.state.listContext
        })
        log.init(newOption, cb)
      } else {
        log.init(options, cb)
      }
    } else {
      cb()
    }
  })
}

function jump206(downloadUrl) {
  utils
    .ajax({
      url: 'https://wxd.tuitortoise.com/api/record',
      data: {
        apiKey: 'ce2eab4d27db0b517526',
        downloadUrl
      },
      method: 'get'
    })
    .then(result => {
      if (result.code === 0) {
        result.data && result.data.jumpUrl
          ? jumpTo(result.data.jumpUrl)
          : jumpTo(downloadUrl)
      } else {
        jumpTo(downloadUrl)
      }
    })
    .catch(() => {
      jumpTo(downloadUrl)
    })
}

function getMd5(keys) {
  const obj = {}
  keys.forEach(item => {
    if (utils.getUrlParameter(item)) {
      obj[item] = utils.getUrlParameter(item)
    }
  })
  return obj
}

function jumpTo(url) {
  // 检测回传
  const { enable, url: reportUrl } = store.state.report || {}
  if (enable && url) {
    // 如果跳转链接和回测链接相同，则将跳转链接拼上参数
    if (reportUrl === url) {
      url = utils.formatUrl(url, {
        a_oId: utils.getUrlParameter('a_oId')
      })
    } else {
      utils
        .ajax({
          url: reportUrl,
          params: {
            a_oId: utils.getUrlParameter('a_oId'),
            device: utils.getUrlParameter('device'),
            ...getMd5(['imeiMd5', 'idfaMd5', 'oaidMd5'])
          },
          method: 'get'
        })
        .then(res => {
          console.log(res)
        })
    }
  }
  // 延迟跳转，防止埋点丢失
  setTimeout(() => {
    // 需要一同提交给广告主的当前url上的参数数组
    const postBackStr = ['device']
    let urlWithPostBackStr = url
    // 如果跳转链接为apk 则直接跳转
    if (urlWithPostBackStr.indexOf('.apk') !== -1) {
      window.location.href = urlWithPostBackStr
      return
    }
    postBackStr.map(str => {
      if (
        utils.getUrlParameter(str) !== '' &&
        utils.getUrlParameter(str, urlWithPostBackStr) === ''
      ) {
        urlWithPostBackStr =
          urlWithPostBackStr.indexOf('?') !== -1
            ? `${urlWithPostBackStr}&${str}=${utils.getUrlParameter(str)}`
            : `${urlWithPostBackStr}?${str}=${utils.getUrlParameter(str)}`
      }
    })
    window.location.href = urlWithPostBackStr
  }, 200)
}
