const path = require('path')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')

const getStyle = isDev => {
  const specPath = [
    path.resolve(__dirname, '../node_modules'),
  ]
  const loader = isDev ? 'style-loader' : MiniCssExtractPlugin.loader
  const cssSourceMap = !!isDev
  const rule = [
    {
      // 手机版CSS处理
      test: /(\.less|\.css)$/,
      exclude: specPath,
      use: [
        { loader: loader },
        {
          loader: 'css-loader',
          options: {
            sourceMap: true,
            modules: true,
            localIdentName: '[local]_[hash:base64:5]'
          }
        },
        {
          loader: 'px2rem-loader',
          options: {
            remUnit: 200
          }
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: cssSourceMap
          }
        }
      ]
    },
    {
      test: /\.(le|c)ss/,
      include: specPath,
      use: [
        {
          loader: loader
        },
        {
          loader: 'css-loader?sourceMap'
        },
        {
          loader: 'px2rem-loader',
          options: {
            remUnit: 100
          }
        },
        {
          loader: 'less-loader',
          options: {
            javascriptEnabled: true,
            sourceMap: isDev
          }
        }
      ]
    },
  ]

  return rule
}

module.exports = {
  getStyle
}