const path = require('path');
const merge = require('webpack-merge');
const webpackBaseConfig = require('./webpack.base.js');
// 清理构建目录下的文件
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
const { getStyle } = require('./webpack.util');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const FileManagerPlugin = require('filemanager-webpack-plugin');
// const BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin;

module.exports = merge(webpackBaseConfig, {
  mode: 'production',
  entry: {
    renderV2: path.resolve(__dirname, '../src/index.js')
  },
  module: {
    rules: [].concat(getStyle(false))
  },
  plugins: [
    new CleanWebpackPlugin(),
    // new BundleAnalyzerPlugin(),
    new MiniCssExtractPlugin({
      // 类似 webpackOptions.output里面的配置 可以忽略
      filename: 'assets/[contenthash:8].[name].css',
      chunkFilename: 'assets/[contenthash:8].[name].css',
    }),
    new FileManagerPlugin({
      onEnd: [
        {
          copy: [
            {
              source: path.join(__dirname, '../dist/html/render-v2.html'),
              destination: path.join(__dirname, '../../../dist/html/render-v2.html')
            }
          ]
        }
      ]
    })
  ]
});
