const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');
const { CleanWebpackPlugin } = require('clean-webpack-plugin');
// vue-loader 编译vue文件
const VueLoaderPlugin = require('vue-loader/lib/plugin');
const HtmlWebpackHarddiskPlugin = require('html-webpack-harddisk-plugin')
const config = require('./config');

const isProd = process.env.NODE_ENV === 'prod';

module.exports = {
  output: {
    path: path.join(__dirname, '../dist'),
    filename: isProd ? `assets/[contenthash:8].[name].js` : '[name].js',
    publicPath: isProd ? config['build'].assetsPublicPath : '/',
    chunkFilename: isProd ? 'assets/[contenthash:8].[name].js' : '[name].js'
  },
  module: { // 处理项目中的不同类型的模块。
    rules: [ // rules 各种规则(数组类型) 每个规则可以分为三部分 - 条件(condition)，结果(result)和嵌套规则(nested rule)
      {
        test: /\.vue$/,
        loader: 'vue-loader' // vue-loader 编译vue模块
      },
      {
        test: /\.(js|jsx)$/,
        loader: 'babel-loader?cacheDirectory=true',
        exclude: /node_modules/
      },
      {
        test: /\.(gif|jpg|png|woff|svg|eot|ttf)\??.*$/,
        loader: 'url-loader',
        options: {
          limit: 10 * 1024,
          // 根据环境使用cdn或相对路径
          publicPath: isProd ? config['build'].assetsPublicPath + 'assets' : 'src/styles/imgs/',
          // 将图片打包到dist/assets文件夹下, 不配置则打包到dist文件夹下
          outputPath: 'assets',
          // 配置打包后图片文件名
          name: isProd ? '[name][hash:7].[ext]' : '[name].[ext]'
        }
      },
      {
        test: /\.(html|tpl)$/,
        loader: 'html-loader'
      },
      {
        test: /\.ejs$/,
        loader: 'ejs-loader'
      }
    ]
  },
  resolve: {
    // 引入路径是不用写对应的后缀名
    extensions: ['.js', '.jsx', '.vue', '.json'],
    alias: {
      // 用@直接指引到src目录下
      '@': path.resolve(__dirname, '../src'),
    }
  },
  externals: {
    vue: 'Vue'
  },
  plugins: [
    new CleanWebpackPlugin(),
    new HtmlWebpackPlugin({ // 构建html
      JIMU_ENV: process.env.NODE_ENV,
      alwaysWriteToDisk: true,
      filename: 'html/render-v2.html',
      chunks: ['renderV2'],
      template: path.resolve(__dirname, '../src/index.html')  // 参照模板样式
    }),
    new HtmlWebpackHarddiskPlugin(),
    new VueLoaderPlugin(), // vue-loader插件开启
  ]
};