const express = require('express')
const webpack = require('webpack')
const webpackDevMiddleware = require('webpack-dev-middleware')
const webpackHotMiddleware = require('webpack-hot-middleware')
const proxy = require('http-proxy-middleware')
const path = require('path')
const fs = require('fs')

const app = express()
const config = require('./webpack.dev.js')
const compiler = webpack(config)
const instance = webpackDevMiddleware(compiler, {
  publicPath: config.output.publicPath
})

app.use(instance)
instance.waitUntilValid(() => {
  require('opn')('http://localhost:3333/render-v2', {
    app: ['google chrome', '--incognito']
  })
})
app.use(webpackHotMiddleware(compiler))

// 加载模板引擎
app.set('views', path.join(__dirname, '../dist/html'))
app.engine('.html', require('ejs').__express)
app.set('view engine', 'html')

app.use('/render-v2', function(req, res) {
  res.setHeader('X-Frame-Options', 'allow-from *')
  const isSupportWebp = req.headers['accept'].toLowerCase().includes('image/webp')
  res.render('render-v2', {
    env: process.env.NODE_ENV,
    isSupportWebp
  })
})

app.use(
  express.static('./', {
    extensions: ['html']
  })
)

if (process.env.NODE_ENV === 'dev') {
  app.use(
    '/',
    proxy({
      target: 'http://localhost:3010'
    })
  )
} else {
  // 本地mock数据
  app.use((req, res) => {
    const path = req.path
    res.set('Content-Type', 'application/json')
    console.log(path)
    try {
      res.send(fs.readFileSync(__dirname + '/../mock' + path + '.json'))
    } catch (e) {
      res.send(
        JSON.stringify({
          code: '1000',
          desc: '无此mock数据'
        })
      )
    }
  })
}


const port = 3333
app.listen(port)
