const rule = {
  id: {
    pattern: /^\d{0,20}$/,
    message: '只能是数字'
  },
  ids: {
    pattern: /^\d{0,20}(,\d{0,20})*$/,
    message: '输入的格式有误'
  },
  name: {
    max: 20,
    message: '最多不超过20个字'
  },
  email: {
    pattern: /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/,
    message: '邮箱格式错误'
  },
  cellphone: {
    pattern: /(^(13\d|14[57]|15[^4,\D]|17\d|18\d)\d{8}|170[059]\d{7})$/,
    message: '请输入正确的手机号码'
  },
  telephone: {
    pattern: /^((0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$/,
    message: '请输入正确的电话号码'
  },
  isInt: {
    pattern: /^([0-9]*[1-9][0-9]*|0)$/,
    message: '请输入正确的整数'
  }
}

module.exports = rule
