import TWEEN from '@tweenjs/tween.js'

export const isElement = function(obj) {
  return !!(obj && (obj.nodeType === 1 || obj.nodeType === 9))
}

function animate(time) {
  window.requestAnimationFrame(animate)
  TWEEN.update(time)
}
window.requestAnimationFrame(animate)

export const twinklingDomGen = function() {
  // 声明缓存
  let cache = []
  return ({ dom, r = 24, g = 144, b = 255 }) => {
    return new Promise(resolve => {
      // 判断是否命中缓存
      let index = cache.findIndex(item => item === dom)
      if (index !== -1) return
      // 加入缓存
      cache.push(dom)
      // 缓存dom原背景颜色
      let resetColor = dom.style.backgroundColor
      // 动态生成rgba
      let genColor = function genColor(opacity = 0) {
        return `rgba(${r}, ${g}, ${b}, ${opacity})`
      }
      // 定义统一
      let obj = { a: 0 }
      // 缓动计时
      // console.time('color tween耗时')
      // 初始化背景颜色
      dom.style.backgroundColor = genColor()
      const opacity = 0.85
      const duration = 300
      new TWEEN.Tween(obj)
        .to({ a: opacity }, duration)
        .easing(TWEEN.Easing.Quadratic.Out)
        .onUpdate(() => {
          // 更改dom背景颜色
          dom.style.backgroundColor = genColor(obj.a)
        })
        .onComplete(() => {
          new TWEEN.Tween(obj)
            .to({ a: 0 }, duration)
            .easing(TWEEN.Easing.Quadratic.Out)
            .onUpdate(() => {
              // 更改dom背景颜色
              dom.style.backgroundColor = genColor(obj.a)
            })
            .onComplete(() => {
              // 还原dom背景颜色
              dom.style.backgroundColor = resetColor
              // 删除缓存
              cache.splice(index, 1)
              resolve()
              // console.timeEnd('color tween耗时')
            })
            .start()
        })
        .start()
    })
  }
}

// 由于是从浏览器中直接发起请求到服务端，所以此处应该只能用环境变量区分域名
export const getJavaSiteHost = () => {
  let NODE_ENV = process.env.JIMU_ENV
  switch (NODE_ENV) {
    case 'dev':
      return 'site.tuiadev.cn'
    case 'test':
    case 'aliyunTest':
      return 'site.tuiatest.cn'
    case 'pre':
      return 'site.tuiapre.cn'
    case 'prod':
      return 'site.tuia.cn'
    default:
      return '172.16.47.145:1112'
  }
}

export const submitForm = function submitForm({
  params,
  method = 'post',
  action = ''
}) {
  const form = document.createElement('form')
  form.action = action
  form.method = method
  form.style.display = 'none'
  Object.keys(params).forEach(key => {
    if (typeof params[key] === 'object') {
      console.log(params[key])
      if (params[key] instanceof Array) {
        // 数组参数
        const arr = params[key]
        arr.forEach((item, idx) => {
          Object.keys(item).forEach(k2 => {
            let input = document.createElement('input')
            input.setAttribute('name', `${key}[${idx}].${k2}`)
            input.setAttribute('value', item[k2])
            form.appendChild(input)
          })
        })
      } else {
        // 对象参数
        const input = document.createElement('input')
        input.setAttribute('name', key)
        input.setAttribute('value', JSON.stringify(params[key]))
        form.appendChild(input)
      }
    } else {
      // 非对象参数
      const input = document.createElement('input')
      input.setAttribute('name', key)
      input.setAttribute('value', params[key])
      form.appendChild(input)
    }
  })
  document.body.appendChild(form)
  console.log(form)
  form.submit()
}
