import React, { Component } from 'react'
import Widget from 'wp/constructors/widget/index'
import store from 'wp/store'
import { sceneUniqueId } from 'wp/config'
import { getNumber } from 'wp/utils/helper'
import WechatElement from './element'

// 闭包内的局部变量,被所有部件共用
let removeHandlers = {}
@Widget({
  resizer: {
    ro: 'hidden',
    ct: 'hidden',
    lt: 'hidden',
    rt: 'hidden',
    rm: 'hidden',
    rb: 'hidden',
    cb: 'hidden',
    lb: 'hidden',
    lm: 'hidden'
  },
  mover: {
    left: false,
    top: true
  },
  onWidgetMount({ targetId }) {
    // 注册钩子
    removeHandlers[targetId] = store.WPHookStore.addHook(
      'onSceneInnerHeightChangeEnd',
      () => {
        const fixed = store.WPSceneStore.getItemPropById(targetId, 'fixed')
        if (fixed.type === 'none') return
        const SceneInnerRect = document
          .getElementById(sceneUniqueId)
          .getBoundingClientRect()
        const TargetRect = document
          .querySelector(`[wid="${targetId}"]`)
          .getBoundingClientRect()
        store.WPSceneStore.changeItemPropsById(targetId, {
          'style.left': 0,
          'style.top':
            fixed.type === 'bottom'
              ? getNumber(SceneInnerRect.height) -
                getNumber(TargetRect.height) +
                'px'
              : 0
        })
      }
    )
  },
  onWidgetWillUnmount({ targetId }) {
    // 注销钩子
    removeHandlers[targetId]()
  }
})
export default class WechatWidget extends Component {
  render() {
    const { fixed } = this.props.widgetAttrs
    const { changeMover } = this.props
    if (fixed.type !== 'none') {
      changeMover('top', false)
    } else {
      changeMover('top', true)
    }
    return <WechatElement widgetAttrs={this.props.widgetAttrs} />
  }
}
