import React, { Component } from 'react'
import CommonStyle from 'wp/config/commonStyle'

export default class WechatElement extends Component {
  render() {
    const { wechat, btn, style } = this.props.widgetAttrs

    return (
      <div
        style={{
          display: 'flex',
          justifyContent: 'space-between',
          backgroundColor: style.backgroundColor,
          height: '100%',
          alignItems: 'center',
          padding: '0 16px'
        }}
      >
        <div style={{ display: 'flex', alignItems: 'center' }}>
          <img src={wechat.avatar.src} style={wechat.avatar.style} />
          <div
            style={{
              color: CommonStyle['@primary-font-color'],
              fontSize: CommonStyle['@secondary-sys-font-size'],
              marginLeft: 8
            }}
          >
            {wechat.name.text}
          </div>
        </div>
        <div style={btn.style}>{btn.text}</div>
      </div>
    )
  }
}
