import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Upload, message, Icon, Input, Radio, InputNumber, Switch } from 'antd'
import styles from '../edits.less'
import { WechatType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import { formItemProps, pxFormatter } from '../helper'
import { observer, inject } from 'mobx-react'
import Divider from 'wp/constructors/fc/divider'
import {
  beforeUploadGen,
  uploadStatusChangeGen,
  uploadParamsGen,
  uploadBucket,
  imagePrefix
} from 'wp/config'
import ColorPicker from 'pro/components/color-picker'
import { getNumber } from 'wp/utils/helper'

const TabPane = Tabs.TabPane
const FormItem = Form.Item
const RadioGroup = Radio.Group

@Editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    size: 'disabled',
    rotate: 'hidden'
  }
})
@inject('WPSceneStore')
@observer
export default class WechatEditor extends Component {
  state = {
    loading: false
  }
  render() {
    const { target, handleChange, WidgetNameCom } = this.props
    const { dpr } = this.props.WPSceneStore.scene
    const { fixed } = target
    const uploadButton = (
      <div>
        <Icon type={this.state.loading ? 'loading' : 'plus'} />
        <div className="ant-upload-text" />
      </div>
    )
    const { wechat, style, btn } = target
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="微信" key="1">
            <Row style={{ marginBottom: '8px' }}>
              <Col offset={1} span={22}>
                {WidgetNameCom}
              </Col>
            </Row>
            <Divider />
            <Form layout="inline">
              <FormItem label="微信头像" {...formItemProps}>
                <Upload
                  name="avatar"
                  {...{
                    ...uploadParamsGen(),
                    listType: 'picture-card',
                    showUploadList: false,
                    className: 'scene-background-uploader',
                    beforeUpload: beforeUploadGen(),
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'uploading') {
                        this.setState({ loading: true })
                        return
                      }
                      if (info.file.status === 'done') {
                        handleChange({
                          'wechat.avatar.src': `${imagePrefix}${uploadBucket}${info.file.name}`
                        })
                      } else if (info.file.status === 'error') {
                        message.error(`${info.file.name}。文件上传失败`)
                      }
                    })
                  }}
                >
                  {wechat.avatar ? (
                    <img src={wechat.avatar.src} style={{ maxWidth: '100%' }} />
                  ) : (
                    uploadButton
                  )}
                </Upload>
              </FormItem>
              <FormItem label="微信名称" {...formItemProps}>
                <Input
                  value={wechat.name.text}
                  onChange={e => handleChange({ 'wechat.name.text': e.target.value })}
                />
              </FormItem>
              <FormItem label="微信号" {...formItemProps}>
                <Input
                  value={wechat.username}
                  onChange={e => handleChange({ 'wechat.username': e.target.value })}
                />
              </FormItem>
              <FormItem label="卡片背景" {...formItemProps}>
                <div style={{ height: 39, width: 56, display: 'flex', alignItems: 'center' }}>
                  <ColorPicker
                    value={style.backgroundColor}
                    onChange={color => handleChange({ 'style.backgroundColor': color })}
                  />
                </div>
              </FormItem>
              <FormItem label="按钮颜色" {...formItemProps}>
                <div style={{ height: 39, width: 56, display: 'flex', alignItems: 'center' }}>
                  <ColorPicker
                    value={btn.style.backgroundColor}
                    onChange={color => handleChange({ 'btn.style.backgroundColor': color })}
                  />
                </div>
              </FormItem>
              <FormItem label="展示位置" {...formItemProps}>
                <RadioGroup
                  value={fixed.type}
                  onChange={e => {
                    let obj = {
                      'fixed.type': e.target.value
                    }
                    // const SceneInnerRect = document
                    //   .getElementById(sceneUniqueId)
                    //   .getBoundingClientRect()
                    if (e.target.value === 'bottom') {
                      // obj['style.top'] =
                      //   getNumber(SceneInnerRect.height) - getNumber(style.height) + 'px'
                      obj['style.top'] = 'auto'
                      obj['style.bottom'] = '0px'
                    }
                    if (e.target.value === 'top') {
                      obj['style.top'] = '0px'
                      obj['style.bottom'] = 'auto'
                    }
                    handleChange(obj)
                  }}
                >
                  <Radio value="bottom">
                    底部
                  </Radio>
                  <Radio value="top">
                    顶部
                  </Radio>
                  <Radio value="none">
                    无
                  </Radio>
                </RadioGroup>
              </FormItem>
              <FormItem label="设为转化" {...formItemProps}>
                <Switch
                  checked={target.jump.isCoversion === undefined ? true : Boolean(target.jump.isCoversion)}
                  onChange={value => handleChange({ 'jump.isCoversion': value ? 1 : 0 })}
                />
              </FormItem>
              <FormItem label="禁止唤起微信" {...formItemProps}>
                <Switch
                  checked={target.jump.isEvokeDisable === undefined ? false : Boolean(target.jump.isEvokeDisable)}
                  onChange={value => handleChange({ 'jump.isEvokeDisable': value ? 1 : 0 })}
                />
              </FormItem>
              <Divider />
              <Row type="flex" align="middle" style={{ height: 39 }}>
                <Col span={2} offset={4}>
                  X
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(style.left) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    disabled
                  />
                </Col>
                <Col span={2} offset={3}>
                  Y
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(style.top) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    step={dpr}
                    disabled={fixed.type !== 'none'}
                    onChange={value => handleChange({ 'style.top': value / dpr + 'px' })}
                  />
                </Col>
              </Row>
              <Row type="flex" align="middle" style={{ height: 39 }}>
                <Col span={2} offset={4}>
                  宽
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(style.width) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    min={0}
                    disabled
                  />
                </Col>
                <Col span={2} offset={3}>
                  高
                </Col>
                <Col span={6}>
                  <InputNumber
                    value={getNumber(style.height) * dpr}
                    formatter={pxFormatter.formatter}
                    parser={pxFormatter.parser}
                    style={{ width: '100%' }}
                    min={0}
                    disabled
                  />
                </Col>
              </Row>
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
