import React from 'react'
import Style from './turntable.rem.less'

export default class Turntable extends React.Component {
  render() {
    const { visualElement, awardSetting } = this.props.target
    const { bgImg, btnImg, guideImg, borderColor } = visualElement
    return (
      <div className={Style.turntable}>
        <div
          className={Style.turntable_bgColor}
          style={{ backgroundColor: borderColor }}
        />
        <img
          src="//yun.tuisnake.com/h5/activity/turntable_circle/images/radius-2.png"
          alt=""
          className={Style.turntable_bgBorder}
          onDragStart={event => {
            event.preventDefault()
          }}
        />
        <div className={Style.turntable_bg}>
          {bgImg && (
            <img
              src={bgImg}
              className={Style.turntable_bg_bgImg}
              onDragStart={event => {
                event.preventDefault()
              }}
            />
          )}
          {btnImg && (
            <img
              src={btnImg}
              className={Style.turntable_bg_Click}
              onDragStart={event => {
                event.preventDefault()
              }}
            />
          )}
          {awardSetting.map((item, index) => {
            return (
              <div
                className={Style.turntable_bg_secImg}
                style={{
                  transform: `rotate(${60 * (index + 1)}deg) skewY(30deg)`
                }}
                key={index}
              >
                {item.img && (
                  <div className={Style.turntable_bg_secImg_inner}>
                    {item.awardName}
                    <img
                      src={item.img}
                      onDragStart={event => {
                        event.preventDefault()
                      }}
                    />
                  </div>
                )}
              </div>
            )
          })}
        </div>
        {guideImg && (
          <img
            className={Style.turntable_pointer}
            src={guideImg}
            onDragStart={event => {
              event.preventDefault()
            }}
          />
        )}
      </div>
    )
  }
}
