import React from 'react'
import { Table, Icon, Upload, message, Popconfirm } from 'antd'
import CommonEditor from 'pro/components/common-editor'
import { uploadBucket, imagePrefix, beforeUploadGen, uploadParamsGen, staticResourcePrefix, uploadStatusChangeGen } from 'wp/config'
import { observer, inject } from 'mobx-react'
import Style from './index.less'
import { deepClone } from 'wp/utils/helper'
import uuidv4 from 'uuid/v4'
import { tableComponents } from 'pro/components/antd-sortable'
import TuiaIcon from 'wp/constructors/fc/icon'
import { PopupType } from 'wp/utils/itemType'

const awardLimit = 6

@inject('WPSceneStore')
@observer
export default class AwardSetting extends React.Component {
  constructor() {
    super(...arguments)
    this.state = {}
  }
  handleChange = (info, index) => {
    if (info.file.status === 'uploading') {
      this.setState({ loading: true })
      return
    }
    if (info.file.status === 'done') {
      this.props.WPSceneStore.changeItemProps({
        [`awardSetting.${index}.img`]: `${imagePrefix}${uploadBucket}${info.file.name}`
      })
    } else if (info.file.status === 'error') {
      message.error(`${info.file.name}。文件上传失败`)
    }
  }
  changeValue = (value, index, key) => {
    this.props.WPSceneStore.changeItemProps({
      [`awardSetting.${index}.${key}`]: value
    })
  }
  render() {
    const { awardSetting, targetId } = this.props
    // hack
    deepClone(awardSetting)
    const columns = [
      {
        title: '',
        dataIndex: 'key',
        key: 'key',
        width: 45,
        className: 'award-table-column',
        render: (_, __, index) => {
          return <div style={{ textAlign: 'center' }}>{index + 1}</div>
        }
      },
      {
        title: '图片',
        dataIndex: 'img',
        key: 'img',
        width: 100,
        className: 'award-table-column',
        render: (_, record, index) => {
          return (
            <div
              style={{ width: 40 }}
              onMouseEnter={() =>
                this.setState({
                  [`x_${index}Close`]: true
                })
              }
              onMouseLeave={() =>
                this.setState({
                  [`x_${index}Close`]: false
                })
              }
            >
              <Upload
                listType="picture-card"
                className="award-uploader"
                showUploadList={false}
                {...uploadParamsGen()}
                beforeUpload={beforeUploadGen()}
                onChange={uploadStatusChangeGen(info => this.handleChange(info, index))}
              >
                {record.img !== '' && <img src={record.img} style={{ width: 38, height: 38 }} />}
                {this.state[`x_${index}Close`] && record.img !== '' && (
                  <TuiaIcon
                    type="icon-system_Close"
                    onClick={e => {
                      e.stopPropagation()
                      this.props.WPSceneStore.changeItemProps({
                        [`awardSetting.${index}.img`]: ''
                      })
                    }}
                  />
                )}
              </Upload>
            </div>
          )
        }
      },
      {
        title: '奖项名称',
        dataIndex: 'awardName',
        key: 'awardName',
        width: 200,
        className: 'award-table-column',
        render: (text, _, index) => {
          return (
            <CommonEditor
              width={200 - 16}
              value={text}
              onChange={value => this.changeValue(value, index, 'awardName')}
            />
          )
        }
      },
      {
        title: '中奖概率',
        dataIndex: 'probability',
        key: 'probability',
        width: 150,
        className: 'award-table-column',
        render: (text, _, index) => {
          return (
            <CommonEditor
              width={150 - 16}
              value={text}
              type="inputNumber"
              step={0.1}
              min={0}
              max={1}
              onChange={value => this.changeValue(value, index, 'probability')}
            />
          )
        }
      },
      {
        title: '出券弹层',
        dataIndex: 'popupId',
        key: 'popupId',
        width: 150,
        className: 'award-table-column',
        render: (text, _, index) => {
          const popups = this.props.WPSceneStore.itemList.filter(item => item.widgetType === PopupType).map(item => ({
            value: item[item.widgetType].id,
            text: item[item.widgetType].name
          }))
          return (
            <CommonEditor
              width={150 - 16}
              value={text}
              type="select"
              initText="选择弹层"
              options={popups}
              onChange={value => this.changeValue(value, index, 'popupId')}
            />
          )
        }
      },
      {
        title: '更多操作',
        key: 'delete',
        width: 100,
        className: 'award-table-column',
        render: (_, __, index) => (
          <Popconfirm
            title="是否确定删除?"
            onConfirm={e => {
              e.stopPropagation()
              if (awardSetting.length === 1) {
                message.warning('至少留一个奖品')
              } else {
                this.props.WPSceneStore.mutateArrayProp(targetId, 'awardSetting', 'splice', index, 1)
              }
            }}
            onCancel={e => e.stopPropagation()}
            okText="确认"
            cancelText="取消"
          >
            <a href="javascript:;" onClick={e => e.stopPropagation()}>
              删除
            </a>
          </Popconfirm>
        )
      }
    ]
    return (
      <div>
        <Table
          size="small"
          columns={columns}
          dataSource={awardSetting}
          scroll={{ y: 400 }}
          pagination={false}
          rowClassName="award-table-row"
          className="sortable-table"
          components={tableComponents}
          onRow={(_, index) => ({
            index,
            moveRow: (dragIndex, hoverIndex) => {
              const { awardSetting, targetId } = this.props
              const dragger = deepClone(awardSetting[dragIndex])
              this.props.WPSceneStore.mutateArrayProp(targetId, 'awardSetting', 'splice', dragIndex, 1)
              this.props.WPSceneStore.mutateArrayProp(targetId, 'awardSetting', 'splice', hoverIndex, 0, dragger)
            }
          })}
        />
        <p className={Style.add_award}>
          <Icon type="plus" />
          <span
            onClick={() => {
              // TODO mobx和react table的问题
              const canAdd = awardSetting.length < awardLimit
              let award = {
                img: `${staticResourcePrefix}/smile.png`,
                awardName: '谢谢参与',
                probability: 0,
                key: uuidv4()
              }
              if (canAdd) {
                this.props.WPSceneStore.mutateArrayProp(targetId, 'awardSetting', 'push', award)
              } else {
                message.warning('此活动最多配置6个奖品，少于6个时需添加“谢谢参与”项')
              }
            }}
          >
            添加奖品
          </span>
        </p>
      </div>
    )
  }
}
