import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { TurntableType } from 'wp/utils/itemType'
import defaultImageAttrs from './attrs'
import { TurntableScreenshot } from 'wp/config/dragScreenshot'
import TuiaIcon from 'wp/constructors/fc/icon'
import store from 'wp/store'

@Item({
  type: TurntableType,
  defaultAttrs: defaultImageAttrs,
  screenshot: TurntableScreenshot,
  onDragIntoScene({ targetId }) {
    store.WPSceneStore.changeItemPropsById(targetId, {
      'baseContent.startTime': Date.now(),
      'baseContent.endTime': Date.now()
    })
  }
})
class TurntableItem extends Component {
  render () {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type="control_turntable" />
        大转盘
      </div>
    )
  }
}

export default TurntableItem
