import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { PopupType } from 'wp/utils/itemType'
import defaultAttrs from './attrs'
import { PopupScreenshot } from 'wp/config/dragScreenshot'
import store from 'wp/store'
import { action } from 'mobx'
import TuiaIcon from 'wp/constructors/fc/icon'

@Item({
  type: PopupType,
  defaultAttrs: defaultAttrs,
  screenshot: PopupScreenshot,
  onDragIntoScene: ({ targetId }) => {
    // 显示遮罩层以及当前弹层内容
    action(store.WPPopupStore.changeOverlay)(true)
    action(store.WPPopupStore.changeId)(targetId)
    action(store.WPPopupStore.refluxItems)([])
  }
})
export default class PopupItem extends Component {
  render() {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type="control_Popup" />
        弹层
      </div>
    )
  }
}
