import React, { Component } from 'react'
import {
  Tabs,
  Row,
  Col,
  Upload,
  message,
  Select,
  Switch,
  InputNumber
} from 'antd'
import styles from '../edits.less'
import { PopupType } from 'wp/utils/itemType'
import {
  beforeUploadGen,
  uploadStatusChangeGen,
  uploadParamsGen,
  staticResourcePrefix
} from 'wp/config'
import { getNetUrl, readImageProps } from 'wp/utils/helper'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import Divider from 'wp/constructors/fc/divider'

const TabPane = Tabs.TabPane
const Option = Select.Option
const Dragger = Upload.Dragger

@Editor({
  type: PopupType,
  basic: {
    jump: {
      options: [
        {
          value: 'close',
          label: '关闭弹层'
        }
      ]
    }
  }
})
@inject('WPSceneStore')
@observer
export default class PopupEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const { target, handleChange, WidgetNameCom, JumpCom } = this.props
    // 旧数据兼容
    if (!target.autoJump) {
      target.autoJump = { enable: 0, delay: 0 }
    }
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="弹层" key="1">
            <Row style={{ marginBottom: '15px' }}>
              <Col offset={1} span={22}>
                {WidgetNameCom}
              </Col>
            </Row>
            <Row style={{ marginBottom: '13px' }}>
              <Col offset={1} span={22}>
                <Dragger
                  {...{
                    ...uploadParamsGen(),
                    beforeUpload: beforeUploadGen({
                      pixel: {
                        width: 660,
                        height: 840
                      }
                    }),
                    showUploadList: false,
                    className: 'popup-uploader',
                    multiple: false,
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        const netUrl = getNetUrl(info.file.name)
                        const { dpr } = this.props.WPSceneStore.scene
                        this.props.handleChange({
                          'image.url': netUrl,
                          'image.isDefault': false
                        })
                        // resize图片尺寸
                        readImageProps(netUrl).then(res => {
                          this.props.handleChange({
                            'image.width': res.width / dpr + 'px',
                            'image.height': res.height / dpr + 'px'
                          })
                        })
                      } else if (info.file.status === 'error') {
                        message.error(`${info.file.name}。文件上传失败`)
                      }
                    })
                  }}
                >
                  {target.image.url ? (
                    <div
                      style={{
                        height: 120,
                        backgroundPosition: 'center',
                        backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
                      }}
                    >
                      <img
                        src={target.image.url}
                        style={{ maxWidth: '100%', maxHeight: '100%' }}
                      />
                    </div>
                  ) : (
                    <div className="draggerUpload">
                      <p className="ant-upload-text">拖拽图片至此区域</p>
                      <p className="ant-upload-hint">支持格式：JPG/PNG/GIF</p>
                      <p className="ant-upload-hint">文件大小：&lt; 1M</p>
                    </div>
                  )}
                </Dragger>
              </Col>
            </Row>
            <Row type="flex" align="middle" style={{ marginBottom: 12 }}>
              <Col
                offset={1}
                span={5}
                style={{ fontSize: 12, color: 'rgba(0, 0, 0, 0.85)' }}
              >
                支持关闭
              </Col>
              <Col span={8}>
                <Select
                  value={target.closeIcon.enable}
                  style={{ width: 140 }}
                  onChange={value =>
                    handleChange({ 'closeIcon.enable': value })
                  }
                >
                  <Option value={1}>是</Option>
                  <Option value={0}>否</Option>
                </Select>
              </Col>
            </Row>
            <Divider />
            {JumpCom}
            <Row type="flex" align="middle" style={{ margin: '10px 0' }}>
              <Col
                offset={1}
                span={5}
                style={{ fontSize: 12, lineHeight: '32px' }}
              >
                自动跳转
              </Col>
              <Col span={12}>
                <Switch
                  checked={Boolean(target.autoJump.enable)}
                  onChange={value =>
                    handleChange({ 'autoJump.enable': value ? 1 : 0 })
                  }
                />
              </Col>
            </Row>
            <Row type="flex" align="middle">
              <Col
                offset={1}
                span={5}
                style={{ fontSize: 12, lineHeight: '32px' }}
              >
                延迟
              </Col>
              <Col span={12}>
                <InputNumber
                  value={target.autoJump.delay}
                  min={0}
                  style={{ width: '48px' }}
                  onChange={value => handleChange({ 'autoJump.delay': value })}
                />
              </Col>
            </Row>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
