import React, { Component } from 'react'
import { observer } from 'mobx-react'
import store from 'wp/store'
import Backend from 'wp/constructors/backend'
import { PopupType } from 'wp/utils/itemType'

@Backend
@observer
export default class Popup extends Component {
  render () {
    const showOverlay = store.WPPopupStore.showOverlay
    const hasPopup = [...store.WPSceneStore.itemList].filter(item => item.widgetType === PopupType).length > 0
    return (
      <React.Fragment>
        {showOverlay && hasPopup && (
          <div
            style={{
              position: 'absolute',
              top: 0,
              bottom: 0,
              left: 0,
              right: 0,
              zIndex: 200,
              backgroundColor: '#000',
              opacity: '.7'
            }}
          />
        )}
      </React.Fragment>
    )
  }
}
