import React, { Component } from 'react'
import TuiaIcon from 'wp/constructors/fc/icon'

export default class MobileElement extends Component {
  render() {
    const { widgetAttrs } = this.props
    const { text, style } = this.props.widgetAttrs
    const { lineHeight, fontSize, textAlign } = style

    return (
      <div
        style={Object.assign(
          { lineHeight, fontSize, textAlign },
          {
            display: 'flex',
            justifyContent: 'center',
            alignItems: 'center',
            height: '100%'
          }
        )}
      >
        {style.backgroundImage ? (
          <React.Fragment />
        ) : (
          <React.Fragment>
            <TuiaIcon
              type="icon-control_phone"
              style={widgetAttrs.icon.style}
            />
            {text}
          </React.Fragment>
        )}
      </div>
    )
  }
}
