import React, { Component } from 'react'
import { Tabs } from 'antd'
import BaseContent from './base-content'
import ControlSetting from './control-setting'
import SubmitVerify from './submit-verify'

const TabPane = Tabs.TabPane

const PlaceholderDiv = function PlaceholderDiv() {
  return <div style={{ height: 10 }} />
}

export default class ModalContent extends Component {
  render() {
    const { target, handleChange } = this.props
    return (
      <Tabs defaultActiveKey="1">
        <TabPane key="1" tab="基本内容">
          <PlaceholderDiv />
          <BaseContent baseContent={target.baseContent} submitVerify={target.submitVerify} handleChange={handleChange} />
        </TabPane>
        <TabPane key="2" tab="控件设置">
          <PlaceholderDiv />
          <ControlSetting targetId={target.id} controlSetting={target.controlSetting} submitVerify={target.submitVerify} handleChange={handleChange} />
        </TabPane>
        <TabPane key="3" tab="提交按钮">
          <PlaceholderDiv />
          <SubmitVerify submitVerify={target.submitVerify} handleChange={handleChange} />
        </TabPane>
      </Tabs>
    )
  }
}
