import React, { Component } from 'react'
import { Form, Input, Select, Radio, Button } from 'antd'
import { formItemProps } from './helper'
import Divider from 'wp/constructors/fc/divider'
import styles from './index.less'
import { REGEX_ENTER } from 'wp/utils/regex'

const FormItem = Form.Item
const Option = Select.Option
const RadioGroup = Radio.Group
const { TextArea } = Input

function PlaceholderDiv({ height }) {
  return <div style={{ height }} />
}

export default class RadioEditor extends Component {
  constructor(props) {
    super(props)
    this.state = {
      data: { ...this.props.data },
      validate_options: {
        validateStatus: '',
        help: ''
      }
    }
  }
  handleChange = (key, value) => {
    this.setState(
      {
        data: Object.assign({}, this.state.data, {
          [key]: value
        })
      },
      this.validate
    )
  }
  validate = () => {
    const { arrangement, options } = this.state.data
    // 为空判断
    if (!options) {
      // this.setState({
      //   validate_options: {
      //     validateStatus: 'error',
      //     help: '请输入选项'
      //   }
      // })
      return false
    }
    const optionsArr = options.split(REGEX_ENTER)
    // 水平排列校验
    if (arrangement === 'horizontal') {
      if (optionsArr.length > 2) {
        this.setState({
          validate_options: {
            validateStatus: 'error',
            help: '横向时，添加的选项标签最多两个'
          }
        })
        return false
      }
      let a = optionsArr.find(item => item.length > 4)
      if (a) {
        this.setState({
          validate_options: {
            validateStatus: 'error',
            help: '每项字数4个字以内'
          }
        })
        return false
      }
    }
    // 垂直排列校验
    if (arrangement === 'vertical') {
      if (optionsArr.length > 50) {
        this.setState({
          validate_options: {
            validateStatus: 'error',
            help: '最多支持增加50个选项'
          }
        })
        return false
      }
      let a = optionsArr.find(item => item.length > 20)
      if (a) {
        this.setState({
          validate_options: {
            validateStatus: 'error',
            help: '每项字数20个字以内'
          }
        })
        return false
      }
    }
    this.setState({
      validate_options: {
        validateStatus: '',
        help: ''
      }
    })
    return true
  }
  handleClick = () => {
    if (!this.validate()) return
    this.props.handleChange(this.state.data)
    this.props.closeDrawer()
  }
  render() {
    const { title, required, options, arrangement } = this.state.data
    // 兼容arrangment为空的情况
    if (!arrangement) {
      this.handleChange('arrangement', 'horizontal')
    }
    return (
      <div className={styles['form']}>
        <Form layout="inline" className={styles['form-inner']}>
          <FormItem label="表单标题" {...formItemProps}>
            <Input
              value={title}
              placeholder="最多20个字符"
              maxLength={20}
              onChange={e => this.handleChange('title', e.target.value)}
            />
          </FormItem>
          <FormItem label="是否必填" {...formItemProps}>
            <RadioGroup value={required} onChange={e => this.handleChange('required', e.target.value)}>
              <Radio value={1}>是</Radio>
              <Radio value={0}>否</Radio>
            </RadioGroup>
          </FormItem>
          <PlaceholderDiv height={16} />
          <Divider />
          <PlaceholderDiv height={14} />
          <FormItem label="排列方式" {...formItemProps}>
            <Select
              value={arrangement}
              style={{ width: 160 }}
              onChange={value => this.handleChange('arrangement', value)}
            >
              <Option value="horizontal">水平排列</Option>
              <Option value="vertical">垂直排列</Option>
            </Select>
          </FormItem>
          <PlaceholderDiv height={6} />
          <FormItem label="选项标签" {...formItemProps} {...this.state.validate_options}>
            <TextArea
              value={options}
              autosize={{ minRows: 4, maxRows: 9 }}
              placeholder={`一行一个值，例如：\r\n红色\r\n蓝色`}
              onChange={e => {
                this.handleChange('options', e.target.value)
              }}
            />
          </FormItem>
        </Form>
        <Button type="primary" className={styles['button']} onClick={this.handleClick} block>
          保存
        </Button>
      </div>
    )
  }
}
