import uuidv4 from 'uuid/v4'

const defaultAttrs = {
  input$$normal: {
    type: 'input',
    childType: 'normal',
    title: '普通',
    placeholder: '请输入',
    verify: 'any',
    required: 1,
    key: 1
  },
  input$$mobile: {
    type: 'input',
    childType: 'mobile',
    title: '手机号',
    placeholder: '请输入您的联系方式',
    verify: 'mobile',
    required: 1,
    key: 2,
    isUnique: 1,
    sendVerifyCode: 1
  },
  input$$email: {
    type: 'input',
    childType: 'email',
    title: '邮箱',
    placeholder: '请输入您的邮箱',
    verify: 'email',
    required: 0,
    key: 3,
    isUnique: 0
  },
  input$$name: {
    type: 'input',
    childType: 'name',
    title: '姓名',
    placeholder: '请输入您的姓名',
    verify: 'name',
    required: 1,
    key: 4
  },
  input$$address: {
    type: 'input',
    childType: 'address',
    title: '详细地址',
    placeholder: '请输入您的详细地址',
    verify: 'any',
    required: 0,
    key: 11
  },
  input$$idcard: {
    type: 'input',
    childType: 'idcard',
    title: '身份证',
    placeholder: '请输入您的身份证号码',
    verify: 'idcard',
    required: 0,
    key: 5,
    isUnique: 1
  },
  select$$customize: {
    type: 'select',
    childType: 'customize',
    title: '自定义',
    placeholder: '请选择',
    verify: 'none',
    required: 1,
    key: 6,
    options: ''
  },
  select$$sex: {
    type: 'select',
    childType: 'sex',
    title: '性别',
    placeholder: '请选择性别',
    verify: 'none',
    required: 0,
    key: 7
  },
  select$$date: {
    type: 'select',
    childType: 'date',
    title: '出生年月',
    placeholder: '请选择出生年月日',
    verify: 'none',
    required: 0,
    key: 8
  },
  select$$time: {
    type: 'select',
    childType: 'time',
    title: '开始时间',
    placeholder: '请选择开始时间',
    verify: 'none',
    required: 0,
    key: 9
  },
  select$$address: {
    type: 'select',
    childType: 'address',
    title: '收货地区',
    placeholder: '请选择您的收货地区',
    verify: 'none',
    required: 0,
    key: 10
  },
  radio$$normal: {
    type: 'radio',
    childType: 'normal',
    title: '选择颜色',
    placeholder: '',
    verify: 'none',
    required: 0,
    key: 12,
    options: '',
    arrangement: 'horizontal'
  },
  checkbox$$normal: {
    type: 'checkbox',
    childType: 'normal',
    title: '选择类型',
    placeholder: '',
    verify: 'none',
    required: 0,
    key: 13,
    options: ''
  },
  textarea$$normal: {
    type: 'textarea',
    childType: 'normal',
    title: '留言',
    placeholder: '留下您的邮箱，方便接收您的购物清单',
    verify: 'none',
    required: 0,
    key: 14
  }
}

export default uniqueType => {
  return Object.assign({}, defaultAttrs[uniqueType], {
    key: uuidv4()
  })
}
