// type分为input,select,inputnumber,radio,checkbox,textarea

// childType分为
// input 有 normal,mobile,email,name,idcard,address
// select 有 normal,sex,date,time,address
// 其余只有normal

// verify取值分别有'none','name','email'.'mobile','idcard'或者Regex

export const verifyOption = [
  {
    text: '手机号',
    value: 'mobile'
  },
  {
    text: '邮箱',
    value: 'email'
  },
  {
    text: '姓名',
    value: 'name'
  },
  {
    text: '身份证',
    value: 'idcard'
  },
  {
    text: '任意',
    value: 'any'
  }
]

// value格式为
// type + '$$' + childType
export const typeOptions = [
  {
    text: '输入框',
    value: 'input$$normal',
    icon: 'icon-system_phone_input'
  },
  {
    text: '手机号',
    value: 'input$$mobile',
    icon: 'icon-system_phone_phone'
  },
  {
    text: '邮箱',
    value: 'input$$email',
    icon: 'icon-system_phone_email'
  },
  {
    text: '姓名',
    value: 'input$$name',
    icon: 'icon-system_phone_user'
  },
  {
    text: '地址',
    value: 'input$$address',
    icon: 'icon-system_phone_addres'
  },
  {
    text: '身份证',
    value: 'input$$idcard',
    icon: 'icon-system_phone_id'
  },
  {
    text: '自定义',
    value: 'select$$customize'
  },
  {
    text: '性别',
    value: 'select$$sex',
    icon: 'icon-system_phone_Sex'
  },
  {
    text: '日期',
    value: 'select$$date',
    icon: 'icon-system_phone_day'
  },
  {
    text: '时间',
    value: 'select$$time',
    icon: 'icon-system_phone_time'
  },
  {
    text: '地区',
    value: 'select$$address',
    icon: 'icon-system_phone_addres'
  },
  // {
  //   text: '计数器',
  //   value: 'inputNumber$$normal'
  // },
  {
    text: '单选框',
    value: 'radio$$normal'
  },
  {
    text: '复选框',
    value: 'checkbox$$normal'
  },
  {
    text: '文本域',
    value: 'textarea$$normal'
  }
]

export const groupSelectOptions = {
  输入框: [
    {
      text: '输入框',
      value: 'input$$normal'
    },
    {
      text: '手机号',
      value: 'input$$mobile'
    },
    {
      text: '邮箱',
      value: 'input$$email'
    },
    {
      text: '姓名',
      value: 'input$$name'
    },
    {
      text: '地址',
      value: 'input$$address'
    },
    {
      text: '身份证',
      value: 'input$$idcard'
    }
  ],
  下拉框: [
    {
      text: '性别',
      value: 'select$$sex'
    },
    {
      text: '日期',
      value: 'select$$date'
    },
    {
      text: '时间',
      value: 'select$$time'
    },
    {
      text: '地区',
      value: 'select$$address'
    },
    {
      text: '自定义',
      value: 'select$$customize'
    }
  ],
  其他: [
    {
      text: '单选框',
      value: 'radio$$normal'
    },
    {
      text: '复选框',
      value: 'checkbox$$normal'
    },
    {
      text: '文本域',
      value: 'textarea$$normal'
    }
  ]
}

export const alreadyHasTypeInit = function alreadyHasTypeInit() {
  let cache = []
  return function alreadyHasType(value) {
    let isExist = cache.includes(value)
    if (isExist) {
      return true
    } else {
      cache.push(value)
      return false
    }
  }
}

export const hasLimit = false
