import React, { Component } from 'react'
import { Row, Col, Slider } from 'antd'
import styles from './index.less'
import { secondaryFontColor } from 'wp/config/commonStyle'
import { observer } from 'mobx-react'
import ColorPicker from 'pro/components/color-picker'
import cn from 'classnames'
import { staticResourcePrefix } from 'wp/config'

const layouts = [
  {
    type: 'left',
    label: '左对齐',
    backgroundImage: `url(${staticResourcePrefix}/form-leftAlign.png)`
  },
  {
    type: 'justify',
    label: '左右对齐',
    backgroundImage: `url(${staticResourcePrefix}/form-justifyAlign.png)`
  },
  {
    type: 'vertical',
    label: '上下对齐',
    backgroundImage: `url(${staticResourcePrefix}/form-verticalAlign.png)`
  },
  {
    type: 'icon',
    label: '图标模式',
    backgroundImage: `url(${staticResourcePrefix}/form-iconModel.png)`
  },
  {
    type: 'no-title',
    label: '无标题',
    backgroundImage: `url(${staticResourcePrefix}/form-notitle.png)`
  }
]
const LabelStyle = {
  width: 48,
  marginLeft: 10,
  marginTop: 8,
  marginRight: 8,
  fontSize: 12,
  lineHeight: '17px',
  color: secondaryFontColor
}

@observer
export default class BaseContent extends Component {
  render() {
    const { layout, style } = this.props.baseContent
    const { handleChange, submitVerify } = this.props
    return (
      <div>
        <Row style={{ marginBottom: 24 }}>
          <Col span={2} style={LabelStyle}>
            样式布局
          </Col>
          <Col span={16}>
            {layouts.map((item, index) => {
              const isThisLayout = layout === item.type
              return (
                <div
                  key={index}
                  className={cn({
                    [styles['layout-item']]: true,
                    [styles['active']]: isThisLayout
                  })}
                  onClick={() => {
                    handleChange({
                      'baseContent.layout': item.type
                    })
                    let timer = setTimeout(() => {
                      // 计算内部元素高度
                      let a = document.querySelectorAll('#___form_wrapper___ > *')
                      let height = 0
                      a.forEach(node => {
                        height += node.offsetHeight
                      })
                      handleChange({
                        'style.height': height + submitVerify.dis + 'px'
                      })
                      clearTimeout(timer)
                    }, 1)
                  }}
                  style={{ backgroundImage: item.backgroundImage }}
                />
              )
            })}
          </Col>
        </Row>
        <Row style={{ marginBottom: 24 }}>
          <Col span={2} style={Object.assign({}, LabelStyle, { marginTop: 4 })}>
            表单文字
          </Col>
          <Col span={16} style={{ width: 64 }}>
            <ColorPicker
              size="small"
              placement="right"
              value={style.color}
              onChange={value => handleChange({ 'baseContent.style.color': value })}
            />
          </Col>
        </Row>
        <Row style={{ marginBottom: 12 }}>
          <Col span={2} style={Object.assign({}, LabelStyle, { marginTop: 4 })}>
            表单背景
          </Col>
          <Col span={16} style={{ width: 64 }}>
            <ColorPicker
              size="small"
              placement="right"
              value={style.backgroundColor}
              onChange={value => handleChange({ 'baseContent.style.backgroundColor': value })}
            />
          </Col>
        </Row>
        <Row>
          <Col span={2} style={Object.assign({}, LabelStyle, { marginTop: 9 })}>
            不透明度
          </Col>
          <Col span={16} style={{ width: 140 }}>
            <Slider
              style={{ marginLeft: 0, marginTop: 12 }}
              value={style.opacity * 100}
              step={10}
              size="small"
              min={0}
              max={100}
              onChange={value => handleChange({ 'baseContent.style.opacity': value / 100 })}
            />
          </Col>
        </Row>
      </div>
    )
  }
}
