import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { FormType } from 'wp/utils/itemType'
import formAttrs from './attrs'
import { FormScreenshot } from 'wp/config/dragScreenshot'
import TuiaIcon from 'wp/constructors/fc/icon'

@Item({
  type: FormType,
  defaultAttrs: formAttrs,
  screenshot: FormScreenshot,
  horizontalCenter: true
})
export default class FormItem extends Component {
  render () {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type='control_form' />
        表单
      </div>
    )
  }
}
