import React from 'react'
import { TextareaItem } from 'antd-mobile'
import { verifyRules } from '../../verify/index'

export default class InputNormal extends React.Component {
  componentDidMount() {}

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      placeholder,
      required,
      verify,
      key
    } = this.props.formAttrs
    const fieldId = `${type}_${childType}-${key}`

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify)
        })(
          <div className="list-input-item">
            <div className="list-input-item-label">{title}</div>
            <div className="list-input-item-content">
              <TextareaItem placeholder={placeholder} rows="3">
                {title}
              </TextareaItem>
            </div>
          </div>
        )}
      </React.Fragment>
    )
  }
}
